! Opens output file for test results in <outputDirectory>
! If <storeExtraInfo>, header rows will be written, indicating what values will be written in each colum

SUBROUTINE OpenTestOutputFile
	USE Declare
	USE FilesModule
	IMPLICIT NONE
	CHARACTER(12) IntToString
	INTEGER ios

		OPEN (FH_GeneralTestOutput, FILE = TRIM(outputDirectory) // TRIM(testingFileName), FORM = writeFormat, IOSTAT = ios)

		IF (storeExtraInfo) THEN
			!Header row 1 (legend)
			WRITE (FH_GeneralTestOutput, *, IOSTAT = ios) "Test output data. Here: test damping function."
            !Header row 2 (legend)
			WRITE (FH_GeneralTestOutput, *, IOSTAT = ios) "Print velocity,        tmp,         d,  and d x v"
			!Header row 3 (empty) 
			WRITE (FH_GeneralTestOutput, '($A27)', IOSTAT = ios) "Selected damping profile # "
			!Header row 4 (empty) 
			WRITE (FH_GeneralTestOutput, '(I1)', IOSTAT = ios) damping
		ENDIF

!	ENDIF
END SUBROUTINE OpenTestOutputFile
